using Microsoft.Win32;
using System;
using System.Diagnostics;
using System.IO;
using System.Windows.Forms;

namespace RegJump
{
    class Program
    {
        static void Main(string[] args)
        {
            Console.WriteLine("RegJump");
            Console.WriteLine("Copyright (c) Jonas Kohl");
            Console.WriteLine("http://tools.jonaskohl.de/regjump.htm\n");
            if (File.Exists("REG_GUI.Z"))
            {
                StartGUI();
                return;
            }

            if (args.Length > 0)
            {
                if (args[0] == "-gui")
                {
                    StartGUI();
                }
                else
                {
                    using (RegistryKey key = Registry.CurrentUser.OpenSubKey(@"Software\Microsoft\Windows\CurrentVersion\Applets\Regedit", true))
                    {
                        if (key == null)
                        {
                            Console.WriteLine("key is null");
                        }
                        else
                        {
                            Console.WriteLine("Setting key to " + args[0]);
                            key.SetValue("LastKey", args[0], RegistryValueKind.String);
                            Process.Start("regedit.exe");
                        }
                    }
                }
            } else
            {
                Console.WriteLine("Usage:");
                Console.WriteLine("regjump <KEY>");
                Console.WriteLine("  or");
                Console.WriteLine("regjump -gui\n");
                Console.WriteLine("If you want it to always start in GUI mode, place a file called REG_GUI.Z in the same directory as the executable.");
            }
        }

        static void StartGUI()
        {
            Console.WriteLine("Starting in GUI mode");
            Application.EnableVisualStyles();
            Application.Run(new MainForm());
        }
    }
}
